
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Radio App Portal</title>
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<style>
    .custom-alert {
        padding: 12px 20px;
        margin: 10px 0;
        border-radius: 6px;
        font-weight: 500;
        position: relative;
        animation: fadeIn 0.3s ease-in-out;
        font-size: 16px;
        line-height:23px;
    }

    .custom-alert.success {
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
        font-size: 16px;
        line-height:23px;
    }

    .custom-alert.error {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
        font-size: 16px;
        line-height:23px;
    }

    .custom-alert.warning {
        background: #fff3cd;
        color: #856404;
        border: 1px solid #ffeeba;
        font-size: 16px;
        line-height:23px;
    }

  .custom-alert .close-btn {
    position: absolute;
    top: 5px;
    right: 10px;
    cursor: pointer;
    font-weight: bold;
    max-width: 18px;
    font-size: 28px;
    height: 16px;
    line-height: 16px;

    }

    .my-modal {
        display: none;
        position: fixed;
        top: 0; left: 0; right: 0; bottom: 0;
        background: rgba(0,0,0,0.5);
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }
    .my-modal-content {
        background: #fff;
        padding: 20px;
        border-radius: 6px;
        width: 400px;
        max-width: 90%;
        box-shadow: 0 0 10px rgba(0,0,0,0.3);
    }

    #updateModal input[type="text"],
    #updateModal input[type="number"],
    #updateModal input[type="color"],
    #updateModal input[type="file"] {
        color: black !important;
        background-color: white !important; /* agar background bhi white chahiye */
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }


</style>

</head>
<body>

<div class="container">
<div class="header">
   <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" class="logo">
    <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
        onclick="event.preventDefault();
                        document.getElementById('logout-form').submit();">
        <?php echo e(__('Logout')); ?>

    </a>

    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
        <?php echo csrf_field(); ?>
    </form>
</div>
<div id="msg"></div>
<div class="form-header">
  <!-- Add Form -->
    <input type="text" id="search" placeholder="Search Here">
    <form id="restaurantForm">
        <input type="text" name="name" placeholder="Restaurant Name" required>
        <input type="file" name="image" required>
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
        <input type="color" name="color_code" required>
        <input type="number" name="r_number" placeholder="Restaurant Number" required>
        <button type="submit">➕ Add Restaurant</button>
    </form>
</div>
  <!-- Table -->
  <div class="table-wrapper">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>Restaurant Name</th>
          <th>Counter ID:</th>
          <th>Status</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody id="restaurantTbody">
        <?php $number=0; ?>
        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($number); ?></td>
                <td><?php echo e($user->restaurant->name); ?></td>
                <td><?php echo e($user->restaurant->r_number); ?></td>
                <td>
                    <label class="switch">
                        <input type="checkbox" class="restaurant_status" data-id="<?php echo e($user->restaurant->id); ?>"
                            <?php echo e($user->restaurant->status=='1' ? 'checked' : ''); ?>>
                        <span class="slider"></span>
                    </label>
                </td>
                <td>
                    <button class="btn btn-sm btn-primary edit-btn">
                        Edit
                    </button>
                </td>
            </tr>
            <?php $number++; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>

   <!-- Pagination Controls -->
    <div class="pagination">
        <button onclick="prevPage()">Prev</button>
        <span id="paginationNumbers"></span>
        <button onclick="nextPage()">Next</button>
    </div>

  </div>
  </div>
</div>

<div class="my-modal" id="updateModal">
  <div class="my-modal-content">
    <span class="close" onclick="closeModal()">×</span>
    <h3>Update Restaurant</h3>
    <form id="updateRestaurantForm" enctype="multipart/form-data">
        <input type="hidden" id="editRestaurantId" name="id">

        <label for="editName">Restaurant Name</label>
        <input type="text" id="editName" name="name" placeholder="Restaurant Name" required>

        <label for="editImage">Image</label>
        <input type="file" id="editImage" name="image" accept="image/*">
        <img id="imagePreview" src="" alt="Image Preview" style="width: 100px; margin-top: 10px; display:none; border-radius: 6px;">

        <label for="editColorCode">Color Code</label>
        <input type="color" id="editColorCode" name="color_code" required>

        <label for="editRNumber">Counter ID</label>
        <input type="number" id="editRNumber" name="r_number" placeholder="Counter ID" required>

        <button type="submit" class="btn-submit">Save Changes</button>
    </form>
  </div>
</div>


<script src="<?php echo e(asset('assets/js/script.js')); ?>"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>

    function closeModal() {
        $('#updateModal').hide();
    }


    $(document).ready(function(){

        // Edit Button Click
        $(document).on('click', '.edit-btn', function(){
            let row = $(this).closest('tr');

            let id = row.find('input.restaurant_status').data('id');
            let name = row.find('td:nth-child(2)').text().trim();
            let rNumber = row.find('td:nth-child(3)').text().trim();

            $.ajax({
                url: "<?php echo e(url('/get-restaurant')); ?>/" + id,
                type: 'GET',
                success: function(response){
                    if(response.data){
                        let data = response.data;
                        $('#editRestaurantId').val(data.id);
                        $('#editName').val(data.name);
                        $('#editRNumber').val(data.r_number);
                        $('#editColorCode').val(data.color_code);

                        if(data.image_url){
                            $('#imagePreview').attr('src', data.image_url).show();
                        } else {
                            $('#imagePreview').hide();
                        }

                        $('#updateModal').css('display', 'flex');
                    } else {
                        alert('Failed to fetch restaurant data');
                    }
                },
                error: function(){
                    alert('Error fetching restaurant data');
                }
            });
        });

        // Create Restaurant
        $('#restaurantForm').submit(function(e){
            e.preventDefault();
            // var formData = $(this).serialize();
            var formData = new FormData(this);

            $.ajax({
                url: "<?php echo e(url('/create-restaurant')); ?>",
                method: "POST",
                processData: false, // ✅ Important for file upload
                contentType: false, // ✅ Important for file upload
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        // ✅ Success Message
                        $("#msg").append(`
                            <div class="custom-alert success">
                            ✅ Restaurant added Successfully
                                <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                            </div>
                        `);

                        // ✅ Append new row in table
                        let restaurant = response.data;
                        let rowCount = $("#restaurantTbody tr").length + 1;

                        $("#restaurantTbody").append(`
                            <tr>
                                <td>${rowCount}</td>
                                <td>${restaurant.name}</td>
                                <td>${restaurant.r_number}</td>
                                <td>
                                    <label class="switch">
                                        <input type="checkbox" class="restaurant_status" data-id="${restaurant.id}" ${restaurant.status == '1' ? 'checked' : ''}>
                                        <span class="slider"></span>
                                    </label>
                                </td>
                            </tr>
                        `);

                        // ✅ Reset form
                        $('#restaurantForm')[0].reset();
                    }
                },
                error: function(xhr) {
                    console.error("Error:", xhr.responseText);
                    $("#msg").append(`
                        <div class="custom-alert warning">
                            ❌ Failed to add Restaurant
                            <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                        </div>
                    `);
                }
            });
        });

        // Update Status
        $('.restaurant_status').change(function() {
            let status = $(this).is(":checked") ? '1' : '0';
            let restaurantId = $(this).data('id');
            $.ajax({
                    url: "<?php echo e(url('/status-change')); ?>/" + status + "/" + restaurantId,
                type: "post",
                data: {
                    _token : '<?php echo e(csrf_token()); ?>',
                    status : status,
                    restaurantId : restaurantId,
                },
                success:function(response){
                    $("#msg").html(""); // purane alerts clear

                    if(response){
                        if(response.enable){
                            $("#msg").append(`
                                <div class="custom-alert success">
                                    ✅ Restaurant Enabled Successfully
                                    <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                                </div>
                            `);
                        } else {
                            $("#msg").append(`
                                <div class="custom-alert warning">
                                    ⚠️ Restaurant Disabled Successfully
                                    <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                                </div>
                            `);
                        }
                    } else {
                        $("#msg").append(`
                            <div class="custom-alert error">
                                ❌ Failed to Change Status
                                <span class="close-btn" onclick="this.parentElement.remove();">×</span>
                            </div>
                        `);
                    }
                }
            });
        });

        // Real Time Search
        $('#search').on('keyup', function(){
            var search = $(this).val();

                $.ajax({
                url: "<?php echo e(url('get-filter-data')); ?>",
                data: { search: search },
                success:function(response){
                    if(response.data){
                        var tbody = '';
                        var number = 0;
                        $.each(response.data, function(index, user){
                            tbody += `<tr>
                            <td>${number}</td>
                            <td>${user.name}</td>
                            <td>${user.r_number}</td>
                            <td>
                                <label class="switch">
                                    <input type="checkbox" class="restaurant_status" data-id="${user.id}" ${(user.status == '1' ? ' checked' : '')}>
                                    <span class="slider"></span>
                                </label>
                            </td>
                            </tr>`;
                            number++;
                        });
                        $('#restaurantTbody').html(tbody);
                    } else {
                        $('#restaurantTbody').html('<tr><td colspan="4">No data found</td></tr>');
                    }
                }
            });




        });

        $('#updateRestaurantForm').submit(function(e) {
            e.preventDefault();

            let formData = new FormData(this);

            $.ajax({
                url: "<?php echo e(url('/update-restaurant')); ?>",
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        alert('Restaurant updated successfully');
                        $('#updateModal').hide();
                        let updated = response.data;

                        $("#restaurantTbody tr").each(function() {
                            let checkbox = $(this).find('.restaurant_status');
                            if(checkbox.data('id') == updated.id) {
                                $(this).find('td:nth-child(2)').text(updated.name);
                                $(this).find('td:nth-child(3)').text(updated.r_number);
                                // status checkbox update if needed
                                checkbox.prop('checked', updated.status == '1');
                            }
                        });

                    } else {
                        alert('Update failed!');
                    }
                },
                error: function(xhr) {
                    alert('Error updating restaurant');
                    console.error(xhr.responseText);
                }
            });
        });


    });

</script>
</body>
</html>
<?php /**PATH C:\wamp64\www\radio\resources\views/dashboard.blade.php ENDPATH**/ ?>