<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Restaurant;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $users= User::with('restaurant')->orderBy('id', 'DESC')->get();
        return view('dashboard', compact('users'));
    }

    public function changeStatus($status, $restaurantID)
    {
        $restaurant = Restaurant::find($restaurantID);

        if ($restaurant) {
            $restaurant->status = $status;
            $restaurant->save();
            return response()->json([
                'enable' => $status == '1' ? true : false,
                'success' => 'Restaurant Updated Successfully'
            ], 200);
        } else {
            return response()->json([
                'error' => 'Restaurant Not Found'
            ], 404);
        }
    }

    public function checkStatus($counter_id)
    {
        $restaurant= Restaurant::where('r_number', $counter_id)->first();
        return response()->json([
            'status' => $restaurant->status==1 ? 'Enable' : 'Disable'
        ], 200);
    }

    public function getFilterData(Request $request)
    {
        $search= strtolower($request['search']);
        $restaurant= Restaurant::where(function($q) use ($search){
            $q->whereRaw('LOWER(name) LIKE ?', ["%{$search}%"])
              ->orWhereRaw('r_number LIKE ?', ["%{$search}%"]);
        })->get();

        return response()->json(['data' => $restaurant], 200);
    }

    public function getrestaurantDetail($restaurantId)
    {
        $restaurant= Restaurant::find($restaurantId);
        if(!$restaurant){
            return response()->json(['data' => 'Not Found'], 404);
        }
        return response()->json(['data' => $restaurant], 200);
    }

    public function getColorCode($restaurantId)
    {
        $restaurant= Restaurant::find($restaurantId);
        if(!$restaurant){
            return response()->json(['color_code' => 'Not Found'], 404);
        }
        return response()->json(['color_code' => $restaurant->color_code], 200);
    }

}
