<?php

namespace App\Http\Controllers\Order;

use App\Models\Order;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class OrderController extends Controller
{

    public function store(Request $request)
    {
        $validator= Validator::make($request->all(), [
            'order_no' => 'required',
        ]);

        if($validator->fails()){
            return response()->json($validator->errors());
        }

        $order= Order::create([
            'order_no' => $request['order_no'],
            'user_id' => Auth::user()->id
        ]);

        return response()->json(['orders' => $order], 200);
    }

    public function getOrders()
    {
        $orders= Order::where('user_id', Auth::id())->get();
        return response()->json(['orders' => $orders], 200);
    }

    public function deleteOrder($id)
    {
        $order= Order::find($id);
        if($order){
            $order->delete();
            return response()->json(['msg' => 'Order Deleted Succuss'], 200);
        }
        return response()->json(['msg' => 'Order Not Found'], 404);
    }
}
